//Simulation of generation of Bivariate Gaussian random vector
//R and S are bivariate gaussian random Variables which are to be generated, with desired mean, sandard deviation and     //covariance
//Windows 10
//Scilab 6.1.0
clear
clc
//sdR=standard deviation of R
sdR=input('Enter the desired standard deviation of R:')
//sdS=standard deviation of S
sdS=input('Enter the desired standard deviation of S:')
//mR=mean of R
mR=input('Enter the desired mean of R:')
//mS=mean of S
mS=input('Enter the desired mean of S:')
//k=correlation coefficient between R and S
k=input('Enter the desired correaltion coefficient between R and S:')
M=input('Enter the number of realizations:')
G=[sdR 0;k*sdS sdS*sqrt(1-k^2)];
for i=1:M
//generation of  two standardized Gaussian random variables P and Q
P=grand(1,1,"nor",0,1);
Q=grand(1,1,"nor",0,1);
//Transformation of P and Q  to the desired mean and covariance
//G=[sdR 0;k.sdS sdS.sqrt(1-k^2)]
//[R S]'=G.*[P Q]'+[mR mS]'
rs=G*[P Q]'+[mR mS]';
RS(:,i)=rs;
end
//verifying the mean of the individual random variables R and S
//meanest is the estimated mean
meanestR=mean(RS(1,:));
meanestS=mean(RS(2,:));
//verifying the covariance matrix
//COV(R,S)=E(RS)-E(R).E(S)
RS1(1,:)=RS(1,:)-meanestR;
RS1(2,:)=RS(2,:)-meanestS;
covest=[0 0;0 0];
//computation of covariance Matrix [var(R) k.sdR.sdS; k.sdR.sdS var(S)]
for i=1:M
    covest=covest+(RS1(:,i)*RS1(:,i)')/M
end
//computation of correlation coefficient between R and S
corcoe=covest(1,2)/ sqrt(covest(1,1)*covest(2,2));
disp('The mean of the random variable R is',meanestR)
disp('The mean of the random variable S is',meanestS)
disp('The Standard deviation of R is',sqrt(covest(1,1)))
disp('The Standard deviation of S is',sqrt(covest(2,2)))
disp('The covariance between R and S is',corcoe)

//output testcase
//desired standard deviation of R: 1
//desired standard deviation of S: 1
//desired mean of R:   1
//desired mean of S:  1
//desired correaltion coefficient between R and S:  0.9
//number of realizations:  2000

//Result
//The mean of the random variable R is 0.9668127(against the desired = 1)
//The mean of the random variable S is 0.9748126(against the desied=1)
//The Standard deviation of R is 1.0276458(against the desired =1)
//The Standard deviation of S is 1.0232880(against the desired =1)
//The covariance between R and S is 0.9015213(against the desired =0.9)

//'grand' function of scilab generates distinct results in different runs of the code.
//Output in each run will be unique


